# 项目七 自动识别技术

## 一、项目要求

1. 实现对物品、设备、数据等实体进行编码注册；


2. 实现对标识编码进行解析，并查询和管理物品信息。

## 二、学习目标

1. 理解自动识别技术的基本概念；
2. 掌握主要自动识别技术类型；
3. 理解自动识别技术在物联网中的应用。

## 三、相关知识

### 1.自动识别技术概述

早期的信息系统是通过人工方式手工录入信息的，数量量十分庞大，劳动强度大，且数据容易出现录入错误。

常见的应用包括：条码打印和扫描设备、二维码、POS机等。

自动识别技术（Auto Identification and Data Capture，AIDC）是一种高度自动化的信息或数据采集技术，以计算机和通信技术的发展为基础的综合性科学技术，其应用识别装置自动获取被识别物品的相关信息，然后提供给计算机后台系统来完成相应的数据处理。



![img](pic/1.jpg) 

### 2.条码识别技术

常见的一维条形码由黑条和白条排成平行线图案

![img](pic/2.jpg) 

常见的二维条形码由某种特定的几何图形按一定规则在平面上分布的黑白相间的图形组成

![img](pic/3.jpg) 

一维条形码使用频率最高的几种码制包括：Code25码、Code39码、Code93码、Code128码、EAN-8码、EAN-13码、ITF25码、库德巴码、UPC-A码、UPC-E码等。

一维条形码一般是水平方向表达信息，优点是编码规则简单，识别设备成本低，缺点是容量小，一般只能包含字母和数字。

二维条形码的码制中，常用的有PDF417、Datamatrix、Maxicode、QR Code、Code49、Code 16K、Code one等。

![img](pic/4.jpg) 

二维条形码在平面上表示信息，相对一维条形码，其优点是密度高，信息容量大，范围广，容错能力强。目前二维条形码应用广泛，如手机可以扫描二维条形码来获取其中的信息，实现快速上网、下载、发送信息等。

### 3.RFID射频识别技术

RFID（Radio Frequency Identification）指射频识别技术，是利用无线射频信号及其空间耦合传输特征，实现对静止或移动的物品自动识别。

RFID的基本原理是利用射频信号交变电磁场的电磁感应或电磁传播方式，自动传输标签芯片存储的信息，从而对目标进行自动识别。

![img](pic/5.jpg) 

RFID具有以下的优势。

（1）非接触识别

（2）识别速度快

（3）携带信息量大

（4）形状大小多元化

## 四、操作步骤

### 步骤1：一物一码系统登录

登录一物一码系统，打开系统地址，输入用户名和密码登录

![img](pic/170.jpg) 

### 步骤2：标识编码申请与查询

根据物品，申请唯一的标识编码，可以选择批次、申请名称、申请数量，以及指定编码规则，编码长度等信息。此外根据需求可以添加防伪码、物品状态以及备注等信息。

![img](pic/171.jpg) 

申请完成之后，可以查看申请状态等信息。等待申请通过即可。

![img](pic/172.jpg) 

### 步骤3：标识编码管理

可以在编码管理界面，查看已经在使用中的编码。了解编码的扫码次数，扫码时间等信息。

![img](pic/173.jpg) 

### 步骤4：扫码记录查询

在扫码记录页面，可以查看更加详细的记录、包括对每一个编码的扫码时间，地点等信息。

![img](pic/174.jpg) 

### 步骤5：防伪查询记录查询

在防伪查询记录当中，可以查看防伪信息的查询情况，查询时间、查询地点等。

![img](pic/175.jpg) 

### 步骤6：报表信息统计

可以在报表信息统计中，二维码数量、扫码量、防伪量等相关信息。

![img](pic/176.jpg) 

## 五、项目总结

​	本章介绍了自动识别技术的概念和分类，通过本章的学习，我们可以对自动识别技术有一个更深刻的认识。